<?php include_once('layout/header.php'); ?>

    <section class="page-header">
        <div class="container">
            <h1 class="heading">About</h1>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active"><a href="#">About</a></li>
            </ul>
        </div>
    </section>

    <section class="container mt-80">
        <div class="row">
            <div class="col-lg-8 mt-20">
                <h2 class="heading">ORGANIZATION <span class="text-primary"> BACKGROUND  </span></h2>
                <p class="lead">Hygiene Village Project (HVP) is a local NGO that implements water, sanitation, hygiene promotion and environmental
				management programmes/projects. It was registered in October 
				2004 under the Trustees Act Chap. 5:03 of the laws of the Republic of Malawi.</p>
                <p class="text-justify">
				The organization is also a registered member of Council for 
Non-Governmental Organizations in Malawi (CONGOMA) and the NGO Board. HVP is a member of 
Water and Environmental Sanitation Network (WESNET). District Executive Committees (DEC) and District 
Coordinating Teams (DCT) in all Districts it is working.  
</p>
                <p class="text-justify nom">Increased sustainable access to and use of safe water and sanitation services and improved hygiene 
				practices for women and marginalised groups resulting to reduced poverty and improved health, 
				environmental and economic conditions by empowering people and creating an enabling environment 
 
</p>
            </div>
            <div class="col-lg-4 mt-20">
                <aside class="applynow-widget">
                    <img src="images/applynow.png" class="img-fluid center-block" alt="">
                    <div class="apply-info text-center">
                        <p>Do you want to know more about us .</p>
                        <p class="font20">Get in touch with us</p>
                        <a href="about_more.php" class="btn btn-primary">Read More</a>
                    </div>
                </aside>
            </div>
        </div>
    </section>

    <section class="container mt-100">
        <div class="row">
            <div class="col-lg-4">
                <div class="icon-box-3">            <!-- ***** Icon Box Style 3 ***** -->
                    <div class="icon-box-icon">
                        <i class="fa fa-bullseye" aria-hidden="true"></i>
                    </div>
                    <div class="icon-box-content">
                        <h5 class="heading">Our Mission</h5>
                        <span class="text-white">To enable communities to live in total hygienic 
						environment with reduced diseases and death rates. .</span>
                        <br><br> <br><br>
                  
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="icon-box-3">            <!-- ***** Icon Box Style 3 ***** -->
                    <div class="icon-box-icon">
                        <i class="fa fa-crosshairs" aria-hidden="true"></i>
                    </div>
                    <div class="icon-box-content">
                        <h5 class="heading">Our Vision</h5>
                        <span class="text-white">A Malawi community that attains safe water, improved hygiene and sanitation, free from HIV/AIDS.  .</span>
                        </br></br></br></br>
                
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="icon-box-3">            <!-- ***** Icon Box Style 3 ***** -->
                    <div class="icon-box-icon">
                        <i class="fa fa-book" aria-hidden="true"></i>
                    </div>
                    <div class="icon-box-content">
                        <h5 class="heading">Intended partner </h5>
                        <span class="text-white"> 
						
						
Any other partner interested in Water, Sanitation, hygiene, environment and HIV/Aids issues 


                        <br><br>
                    
                    </div>
                </div>
            </div>                
        </div>            
    </section>

    <section class="container mt-100 mb-100">
	<div class="col-lg-12">
                <h2 class="heading text-left">THEMATIC<span class="text-primary"> AREAS</span></h2>
                    <p class="text-justify nom"> 
Hygiene Village Project facilitates and implements developmental projects and programmes that fall under the following thematic areas: Water, Sanitation, hygiene promotion, Environmental management and HIV/AIDS. 
 
 
 
</p> </br>
<h2 class="heading text-left">our <span class="text-primary">OBJECTIVE</span></h2>
                    <p>Increased sustainable access to and use of safe water and sanitation services and improved hygiene 
				practices for women and marginalised groups resulting to reduced poverty and improved health, 
				environmental and economic conditions by empowering people and creating an enabling environment 
 
</p> </br>
<h2 class="heading text-left">our <span class="text-primary">CORE VALUES</span></h2>
 <p class="text-justify nom"> 
•	We are reliable  </br>
•	Trustworthy and honest  </br>
•	We take great care to be fully accountable in our work </br> 
•	We are enthusiastic to achieve sustainable results </br>
•	We are cost-conscious and result-oriented  </br>
•	We value doing right things for the right reasons </br> 
•	We value promotion of innovations in our activities </br>
•	We value our time than our limited resources </br>
•	We respect and inspire the community to achieve their full participation through cooperation and collaboration  

 
</p></br>
<h2 class="heading text-left">STRATEGIC DIRECTION <span class="text-primary"> Programmatic, integrated approach and theory of changeS</span></h2>
 <p class="text-justify nom"> 
Hygiene Village Project intends to change its methodology over the next five years from
 a project-led approach to a programmatic approach to its work. These programmes will have an integrated, 
 holistic approach to health problems, highlighting various aspects of preventative healthcare and 
 institutional development.  The programmatic work will: </br> </br>
i.	Focus on empowering communities to ensure they will demand quality services and engage in healthy behavior 
ii.	Increasing the impact and strengthening local structures in institutionally weak areas  </br>
iii.	Focus on ensuring that communities should afford and sustain WASH services </br>
iv.	Capacity building to government health and WASH providers, CBOs and community stakeholders to
 be responsible and accountable to deliver quality health services in line with the needs of the community </br> 
v.	Involvement of private sector in provision of sustainable WASH services vi. Improving access to
 comprehensive sexual reproductive health (SRH) services to prevent new infections and HIV.  </br> 
 
 
 
 
 </br>On the other hand Hygiene Village intends to increase its potential by working with trusted partners whose main focus is to fulfill people’s rights in WASH, environment and HIV activities. HVP intends to request for partnerships with strategic partners with similar thematic areas both within the country and beyond to jointly accomplish a positive contribution. The organization provides capacity building to key community stakeholders for them to properly manage and reinforce their efforts in water, sanitation, hygiene and HIV issues.  </br></br>
 
Hygiene Village Project developed an M&E tools that make the output and impact easy to track. The tool encourages the staff to be more closely involved with the programme progress; it also creates more opportunity for other partners and stakeholders to be more closely involved in policy development, policy influencing and communication. 


 
 

 
</p>

               
            </div>
         <div class="row">
			
            
            
    </section>

    <div class="bg-light pt-100 pb-100 mt-100">
        <div class="container">
            <div class="row">
			<h2 class="heading">OUR <span class="text-primary">PARTNERS </span></h2>
                <div class="col-lg-12">
                    <div class="logo-scroll owl-carousel">
                        <img src="images/logo-1.png" alt="">
                        <img src="images/logo-2.png" alt="">
                        <img src="images/logo-3.png" alt="">
                        <img src="images/logo-4.png" alt="">
                        <img src="images/logo-5.png" alt="">
						<img src="images/logo-6.png" alt="">
                        <img src="images/logo-7.png" alt="">
                        <img src="images/logo-8.png" alt="">
                        <img src="images/logo-9.png" alt="">
                        <img src="images/logo-10.png" alt="">
						<img src="images/logo-11.png" alt="">
                        <img src="images/logo-12.png" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>

   <?php include_once('layout/footer.php'); ?>