<?php
include_once('header.php');
// Fetch the audio details from DB using $_GET['id']
$audio = $con->getRows('audio_files', array('where' => 'id="'.intval($_GET['id']).'"', 'return_type' => 'single'));
?>
<div class="container mt-4">
    <h2>Edit Audio</h2>
    <form action="sql_statements.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="update_audio" value="1">
        <input type="hidden" name="id" value="<?php echo $audio['id']; ?>">
        <div class="form-group">
            <label>Title</label>
            <input type="text" name="title" class="form-control" value="<?php echo $audio['title']; ?>" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <input type="text" name="description" class="form-control" value="<?php echo $audio['description']; ?>">
        </div>
        <div class="form-group">
            <label>Category</label>
            <select name="category" class="form-control" required>
                <option value="">Select Category</option>
                <?php
                // Fetch categories from audio_categories table
                $categories = $con->getRows('audio_categories', array('order_by'=>'name ASC'));
                foreach ($categories as $cat): ?>
                    <option value="<?php echo $cat['id']; ?>" <?php if(isset($audio['category_id']) && $audio['category_id'] == $cat['id']) echo 'selected'; ?>><?php echo htmlspecialchars($cat['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Change Audio File (optional)</label>
            <input type="file" name="audio" class="form-control">
        </div>
        <button type="submit" class="btn btn-success">Update Audio</button>
    </form>
</div>
<?php include_once('footer.php'); ?> 