<?php
include_once('header.php');
// Fetch the video details from DB using $_GET['id']
$video = $con->getRows('videos', array('where' => 'id="'.intval($_GET['id']).'"', 'return_type' => 'single'));
?>
<div class="container mt-4">
    <h2>Edit Video</h2>
    <form action="sql_statements.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="update_video" value="1">
        <input type="hidden" name="id" value="<?php echo $video['id']; ?>">
        <div class="form-group">
            <label>Title</label>
            <input type="text" name="title" class="form-control" value="<?php echo $video['title']; ?>" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="description" class="form-control"><?php echo $video['description']; ?></textarea>
        </div>
        <div class="form-group">
            <label>Category</label>
            <select name="category" class="form-control" required>
                <option value="">Select Category</option>
                <?php
                $categories = $con->getRows('video_categories', array('order_by'=>'name ASC'));
                foreach ($categories as $cat): ?>
                    <option value="<?php echo $cat['id']; ?>" <?php if(isset($video['category_id']) && $video['category_id'] == $cat['id']) echo 'selected'; ?>><?php echo htmlspecialchars($cat['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Current Video</label><br>
            <?php if (!empty($video['file_path'])): ?>
                <video width="240" height="135" controls>
                    <source src="../../../assets/uploads/videos/<?php echo $video['file_path']; ?>" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
                <br>
                <a href="../../../assets/uploads/videos/<?php echo $video['file_path']; ?>" target="_blank">Download</a>
            <?php else: ?>
                No video file
            <?php endif; ?>
        </div>
        <div class="form-group">
            <label>Change Video File (optional)</label>
            <input type="file" name="video" class="form-control">
        </div>
        <button type="submit" class="btn btn-success">Update Video</button>
    </form>
</div>
<?php include_once('footer.php'); ?> 