<?php include_once('layout/header.php'); ?>

    <section class="page-header">
        <div class="container">
            <h1 class="heading">Events</h1>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active"><a href="#">Events</a></li>
            </ul>
        </div>
    </section>

    <section class="container mt-100 mb-100">
        <div class="row">
            <div class="col-lg-12">
                <h2 class="heading text-center">Upcoming <span class="text-primary">Events</span>
                    <span class="sub-heading">You're welcome to all our events. We would love to see you there!</span>
                    <span class="icon-divider"></span>
                </h2>
            </div>
			<?php
                    $posts = $con->getRows('events', array('where' => 'status=1', 'order_by' => 'date_posted desc'));
                    if (!empty($posts)) {
                        foreach ($posts as $post) {  {
                    ?>
            <div class="col-lg-6">
			
                <div class="card event-card">
				
                    <div class="card-body">
                        <div class="event-head">
                            <div class="event-on">
                                <span class="date">27</span>
                                <span class="month">SEPT</span>
                            </div>
                            <img src="assets/uploads/events/thumbs/<?= $post['thumb'] ?>" class="img-fluid event-img" alt="">
                            <a href="event-details.html" class="event-link"><i class="fa fa-link" aria-hidden="true"></i></a>
                        </div>
                        <div class="event-detail">
                            <h4 class="heading"><?= $post['title'] ?></h4>
                            <span class="brief"><a href="event-details.php?event=<?= $post['event_id'] ?>" class="read-more">Check Details</a>.</span>
                            <ul class="timer" data-date="2018/09/03 02:34:10">           <!-- Put event Date in YYYY/MM/DD hh:mm:ss format -->
                                <li><span class="days"><?= $con->shortDate($post['date']) ?></span>days</li>
                                <li><span class="hours"><?= $post['venue'] ?></span>hrs</li>
                                <li><span class="minutes">00</span>min</li>
                                <li><span class="seconds">00</span>sec</li>
                            </ul>
							
							
                    <?php } ?>
                        </div>
						
						
                    </div>
					
                </div>
				
				
            </div>
            
           
               
        </div>
		
    </section>
    <?php include_once('layout/footer.php'); ?>