<?php include_once('layout/header.php'); ?>
<section class="page-header">
    <div class="container">
        <h1 class="heading">Gallery</h1>
        <ul class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
            <li class="breadcrumb-item active"><a href="#">Gallery</a></li>
        </ul>
    </div>
</section>

<section class="mt-100 mb-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-9">
                <div class="row">
                    <?php
                    $images = $con->getRows('gallery_images', array('order_by'=>'created_at DESC'));
                    if ($images && is_array($images) && count($images) > 0):
                        foreach ($images as $image):
                    ?>
                    <div class="col-lg-6 col-md-6 col-sm-12 mb-4">
                        <div class="gallery-card card">
                            <div class="card-body">
                                <a href="assets/uploads/gallery/<?php echo $image['image_path']; ?>" class="img-zoom" data-toggle="modal" data-target="#lightboxModal" data-img="assets/uploads/gallery/<?php echo $image['image_path']; ?>">
                                    <i class="fa fa-search"></i>
                                </a>
                                <img src="assets/uploads/gallery/<?php echo $image['image_path']; ?>" class="img-fluid" alt="<?php echo htmlspecialchars($image['title']); ?>">
                            </div>
                        </div>
                    </div>
                    <?php
                        endforeach;
                    else:
                    ?>
                    <div class="col-12 text-center">
                        <p>No gallery images found.</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-3">
                <aside class="card widget search-widget">
                    <div class="card-body">
                        <h5 class="heading">Search Gallery</h5>
                        <form class="search form-inline">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search">
                                <span class="input-group-btn">
                                    <button class="btn btn-light" type="button"><i class="fa fa-search fa-fw"></i></button>
                                </span>
                            </div>
                        </form>              
                    </div>  
                </aside>
                <aside class="card widget category-widget">
                    <div class="card-body">
                        <h5 class="heading">Categories</h5>
                        <ul class="categories">
                            <?php
                            $categories = $con->getRows('gallery_categories', array('order_by'=>'name ASC'));
                            if ($categories && is_array($categories)) {
                                foreach ($categories as $cat) {
                                    echo '<li><a href="#">' . htmlspecialchars($cat['name']) . '</a></li>';
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </aside>
                <aside class="card card-no-border widget download-widget text-center">
                    <img src="images/download.jpg" class="card-img" alt="">
                    <div class="card-img-overlay d-flex flex-column justify-content-center">
                        <p class="text-white font24">View our latest project photos</p>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>

<!-- Lightbox Modal -->
<div class="modal fade" id="lightboxModal" tabindex="-1" role="dialog" aria-labelledby="lightboxModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content bg-transparent border-0">
      <img id="lightboxImage" src="" class="img-fluid rounded" alt="Gallery Image">
    </div>
  </div>
</div>

<?php include_once('layout/footer.php'); ?>

<style>
.gallery-card {
    border-radius: 10px;
    overflow: hidden;
    margin-bottom: 24px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.05);
}
.gallery-card .img-zoom {
    display: inline-block;
    margin-bottom: 8px;
    color: #007bff;
    font-size: 1.3rem;
    background: #fff;
    border-radius: 50%;
    padding: 7px 10px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.08);
    transition: background 0.2s, color 0.2s;
}
.gallery-card .img-zoom:hover {
    background: #007bff;
    color: #fff;
    text-decoration: none;
}
.gallery-card img {
    width: 100%;
    height: auto;
    display: block;
    border-radius: 6px;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    var modal = document.getElementById('lightboxModal');
    var lightboxImage = document.getElementById('lightboxImage');
    document.querySelectorAll('.img-zoom').forEach(function(item) {
        item.addEventListener('click', function(e) {
            e.preventDefault();
            var imgSrc = this.getAttribute('data-img');
            lightboxImage.src = imgSrc;
            $('#lightboxModal').modal('show');
        });
    });
    $('#lightboxModal').on('hidden.bs.modal', function () {
        lightboxImage.src = '';
    });
});
</script>