<?php include_once('layout/header.php'); ?>

    <section class="page-header">
        <div class="container">
            <h1 class="heading">Jobs</h1>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active"><a href="#">Jobs</a></li>
            </ul>
        </div>
    </section>

    <section class="mt-100 mb-100">
        <div class="container">
		
			
            <div class="row">
			<?php
                    $posts = $con->getRows('vacancies a, job_categories b', array('where' => 'a.status=1 and a.job_category=b.category_id', 'order_by' => 'date_posted desc'));
                    if (!empty($posts)) {
                        foreach ($posts as $post) { ?>

                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h4 class="nom"><?= $post['job_title'] ?></h4>
                            <a href="#" class="btn btn-primary btn-sm float-right">Apply Now</a>
                        </div>
                        <ul class="list-group list-group-flush">
						<li class="list-group-item"><strong>Job Category :</strong> <?= $post['category'] ?></li>
                            <li class="list-group-item"><strong>Date posted :</strong> <?= $post['date_posted'] ?></li>
                            <li class="list-group-item"><strong>Closing date :</strong> <?= $post['closing_date']?></li>
                            <li class="list-group-item"> <p><?= substr(strip_tags($post['job_description']), 0, 200); ?>...</p></li>
                        </ul>
						
                    </div>
                    
                    
                </div>
				
			<?php	}
				}else{
					echo"There are no new newly apploaded projects";
				}
			?>
			
                <div class="col-lg-4">
                    <aside class="card widget search-widget">
                        <div class="card-body">
                            <h5 class="heading">Search Job</h5>
                            <form class="search form-inline">   <!-- Search Form -->
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Search">
                                    <span class="input-group-btn">
                                        <button class="btn btn-light" type="button"><i class="fa fa-search fa-fw"></i></button>
                                    </span>
                                </div>
                            </form>              
                        </div>  
                    </aside>
                    <aside class="card widget category-widget">
                        <div class="card-body">
                            <h5 class="heading">Job Categories</h5>
                            <ul class="categories">
                                <li><a href="jobs.html">Mathematics <span class="badge badge-pill badge-primary">2</span></a></li>
                                <li><a href="jobs.html">Techonology <span class="badge badge-pill badge-primary">1</span></a></li>
                                <li><a href="jobs.html">Art & Craft <span class="badge badge-pill badge-primary">6</span></a></li>
                                <li><a href="jobs.html">Spoken English <span class="badge badge-pill badge-primary">4</span></a></li>
                                <li><a href="jobs.html">Health & fitness <span class="badge badge-pill badge-primary">2</span></a></li>
                            </ul>
                        </div>
                    </aside>
                    <aside class="card card-no-border widget download-widget text-center">
                        <img src="images/download.jpg" class="card-img" alt="">
                        <div class="card-img-overlay d-flex flex-column justify-content-center">
                            <p class="text-white font24">Join the best people in industry.</p>
                        </div>
                    </aside>
                </div>
            </div>
			
			
			
        </div>
		
		
    </section>
	
<?php include_once('layout/footer.php'); ?>